c======================================================================
c c3v13s ( C3v symmetry, AB3 type Molecule ( e. g. NH3 ),
c                                                 symOrb SPIN version )
c  2006.03.31 Version 1.0 Sakane, Genta
c     ( Department of Chemistry, Okayama University of Science, Japan )
c  2016.11.30 Version 2.0 Genta Sakane added this program from Am to Og
c======================================================================
      program c3v13s
      real*8 a(4,3),b(4,3),bohr,adis,bdis,az,bz,ax,bx,pi,rad,dang,rang,
     &hfdang,hfrang,two,thr,hf,sqt,hfsqt,cosx,sinx
      integer z(4),n(4)
      open (unit=07, form='formatted', status='unknown',
     &      access='sequential', file='c3v13s.out')
      open (unit=08, form='formatted', status='unknown',
     &      access='sequential', file='f01')
      bohr=0.5291772108
      pi=3.1415926535
      rad=180/pi
      write(*,1010)
   10 write(*,1020)
      read(*,*) z(1)
      if(z(1).le.0) then
      write(*,1510)
      write(*,1520)
      write(*,1530)
      go to 10
      else
      go to 20
      end if
   20 if(z(1).gt.118) then
      write(*,1510)
      write(*,1520)
      write(*,1530)
      go to 10
      else
      go to 30
      end if
   30 write(*,1030)
      read(*,*) z(2)
      if(z(2).le.0) then
      write(*,1510)
      write(*,1520)
      write(*,1530)
      go to 30
      else
      go to 40
      end if
   40 if(z(2).gt.118) then
      write(*,1510)
      write(*,1520)
      write(*,1530)
      go to 30
      else
      go to 50
      end if
   50 write(*,1040)
      read(*,*) adis
   60 write(*,1050)
      read(*,*) dang
      if(dang.le.0) then
      write(*,1610)
      write(*,1620)
      write(*,1630)
      go to 60
      else
      go to 70
      end if
   70 if(dang.ge.120) then
      write(*,1610)
      write(*,1620)
      write(*,1630)
      go to 60
      else
      go to 80
      end if
   80 bdis=adis/bohr
      rang=dang/rad
      hfdang=dang/2
      hfrang=rang/2
      thr=3.0
      two=2.0
      hf=0.5
      sqt=sqrt(thr)
      hfsqt=hf*sqt
      cosx=((two/sqt)*adis*sin(hfrang))/adis
      sinx=sqrt(1-(cosx*cosx))
      az=adis*sinx
      bz=bdis*sinx
      ax=(two/sqt)*adis*sin(hfrang)
      bx=(two/sqt)*bdis*sin(hfrang)
      z(3)=z(2)
      z(4)=z(2)
      n(1)=1
      n(2)=2
      n(3)=2
      n(4)=2
      a(1,1)=0
      a(1,2)=0
      a(1,3)=az
      a(2,1)=ax
      a(2,2)=0
      a(2,3)=0
      a(3,1)=-hf*ax
      a(3,2)=hfsqt*ax
      a(3,3)=0
      a(4,1)=-hf*ax
      a(4,2)=-hfsqt*ax
      a(4,3)=0
      b(1,1)=0
      b(1,2)=0
      b(1,3)=bz
      b(2,1)=bx
      b(2,2)=0
      b(2,3)=0
      b(3,1)=-hf*bx
      b(3,2)=hfsqt*bx
      b(3,3)=0
      b(4,1)=-hf*bx
      b(4,2)=-hfsqt*bx
      b(4,3)=0
      write(7,3010)
      write(7,3020)
      write(7,3030)
      do 101 i=1,4
      write(7,1000) b(i,1),b(i,2),b(i,3),n(i)
  101 continue
      write(8,2010)
      do 201 i=1,4
      write(8,2020) z(i),n(i),a(i,1),a(i,2),a(i,3)
  201 continue
      write(8,2030)
      write(8,2040)
      write(8,2030)
      write(8,2050)
      write(8,2060)
      write(8,2070)
      write(8,2080)
      go to 204
  202 write(*,1001)
  203 write(*,1002)
  204 stop
 1000 format(3d20.10,i5)
 1001 format('*** Read Error ***')
 1002 format('*** Data Not Found ***')
 1010 format(/,'*** Program C3v13s (symOrb SPIN version)',/,'*** for AB3
     & type molecule (e. g. NH3)')
 1020 format(/,3x,'Input Atomic Number(Z) (1 <= Z <= 118) of Central Ato
     &m A, Z = ? ',$)
 1030 format(/,3x,'Input Atomic Number(Z) (1 <= Z <= 118) of Terminal At
     &om B, Z = ? ',$)
 1040 format(/,3x,'Input Distance(angstrom), A - B = ? ',$)
 1050 format(/,3x,'Input Angle(degree)( 0 deg.< Angle < 120 deg.), B-A-B
     & = ? ',$)
 1510 format(//,'     **************************************************
     &')
 1520 format('     *** Error *** Atomic Number(Z) (1 <= Z <= 118) ***')
 1530 format('     **************************************************',/
     &)
 1610 format(//,'     ***********************************************')
 1620 format('     *** Error *** B-A-B ( 0 deg.< Angle < 120 deg.)')
 1630 format('     ***********************************************',/)
 2010 format('| Z ||NEQ||   X    ||   Y    ||   Z    |')
 2020 format(2x,i3,1x,i4,3(f10.5))
 2030 format('---------------------------------------------')
 2040 format('|NEQ||  CHG   ||U/D||   RD   ||   VD   |    1')
 2050 format('    0     Unit     (0:angstrom  1:atomic)')
 2060 format('    1     Spin     (0:non-spin  1:spin  )')
 2070 format('    0     M.P.     (0:No        1:Yes   )')
 2080 format('20000     Sample Point ( <100000, =0 autoset )')
 3010 format('    4')
 3020 format('    1    1    1    1')
 3030 format('    1    1    2    0')
      end
