c======================================================================
c C8v11n ( C(infinity)v Symmetry(Continuous Group) NON-SPIN version
c           AB type Linear Heteronuclear Diatomic Molecule (e. g. CO) )
c  2006.03.31 Version 1.0 Sakane, Genta
c     ( Department of Chemistry, Okayama University of Science, Japan )
c  2016.11.30 Version 2.0 Genta Sakane added this program from Am to Og
c======================================================================
      program c8v11n
      real*8 a(2,3),b(2,3),bohr,adisab,adis,bdis
      integer z(2),n(2)
      open (unit=07, form='formatted', status='unknown',
     &      access='sequential', file='c8v11n.out')
      open (unit=08, form='formatted', status='unknown',
     &      access='sequential', file='f01')
      bohr=0.5291772108
  110 write(*,1010)
      write(*,1020)
      write(*,1210)
      read(*,*,err=230) z(1)
      if(z(1).le.0) then
      write(*,2010)
      write(*,2020)
      write(*,2030)
      go to 110
      else
      go to 120
      end if
  120 if(z(1).gt.118) then
      write(*,2010)
      write(*,2020)
      write(*,2030)
      go to 110
      else
      go to 130
      end if
  130 write(*,1220)
      read(*,*,err=230) z(2)
      if(z(2).le.0) then
      write(*,2010)
      write(*,2020)
      write(*,2030)
      go to 110
      else
      go to 140
      end if
  140 if(z(2).gt.118) then
      write(*,2010)
      write(*,2020)
      write(*,2030)
      go to 110
      else
      go to 150
      end if
  150 n(1)=1
      n(2)=2
      write(*,1410)
      read(*,*) adisab
      adis=adisab/2
      bdis=adis/bohr
      a(1,1)=0
      a(1,2)=0
      a(1,3)=adis
      a(2,1)=0
      a(2,2)=0
      a(2,3)=-adis
      b(1,1)=0
      b(1,2)=0
      b(1,3)=bdis
      b(2,1)=0
      b(2,2)=0
      b(2,3)=-bdis
      write(7,3010)
      write(7,3020)
      write(7,3030)
      do 210 i=1,2
      write(7,4010) b(i,1),b(i,2),b(i,3),n(i)
  210 continue
      write(8,5010)
      do 220 i=1,2
      write(8,5020) z(i),n(i),a(i,1),a(i,2),a(i,3)
  220 continue
      write(8,5030)
      write(8,5040)
      write(8,5030)
      write(8,5050)
      write(8,5060)
      write(8,5070)
      write(8,5080)
      go to 240
  230 write(*,6010)
  240 stop
 1010 format(/,'*** Program C(infinity)v11n (Continuous Group) NON-SPIN
     &version ***')
 1020 format('*** for AB type Linear Heteronuclear Diatomic Molecule (e.
     & g. CO)')
 1210 format(/,3x,'Input Atomic Number(Z) (1 <= Z <= 118) of atom A, Z =
     & ? ',$)
 1220 format(/,3x,'Input Atomic Number(Z) (1 <= Z <= 118) of atom B, Z =
     & ? ',$)
 1410 format(/,3x,'Input Distance(angstrom), A - B = ? ',$)
 2010 format(//,'     **************************************************
     &')
 2020 format('     *** Error *** Atomic Number(Z) (1 <= Z <= 118) ***')
 2030 format('     **************************************************',/
     &)
 3010 format('    7')
 3020 format('    1    1    1    1    1    1    1')
 3030 format('    1    2    0    2    0    2    0')
 4010 format(3d20.10,i5)
 5010 format('| Z ||NEQ||   X    ||   Y    ||   Z    |')
 5020 format(2x,i3,1x,i4,3(f10.5))
 5030 format('---------------------------------------------')
 5040 format('|NEQ||  CHG   ||U/D||   RD   ||   VD   |    1')
 5050 format('    0     Unit     (0:angstrom  1:atomic)')
 5060 format('    0     Spin     (0:non-spin  1:spin  )')
 5070 format('    0     M.P.     (0:No        1:Yes   )')
 5080 format('20000     Sample Point ( <100000, =0 autoset )')
 6010 format(/,'*** Read Error ***',/)
      end
