c======================================================================
c d3d26n (D3d symmetry, A2B6 type Molecule (e. g. C2H6),
c                                             symOrb NON-SPIN version )
c  2012.02.16 Version 1.0 Sakane, Genta
c     ( Department of Chemistry, Okayama University of Science, Japan )
c  2016.11.30 Version 2.0 Genta Sakane added this program from Am to Og
c======================================================================
      program d3d26n
      real*8 a(8,3),b(8,3),bohr,adis1,adis2,adis3,adis4,bdis1,bdis2,
     &bdis3,bdis4,pi,rad,dang1,dang2,rang1,rang2,two,thr,hf,sqt,hfsqt
      integer z(8),n(8)
      open (unit=07, form='formatted', status='unknown',
     &      access='sequential', file='d3d26n.out')
      open (unit=08, form='formatted', status='unknown',
     &      access='sequential', file='f01')
      bohr=0.5291772108
      pi=3.1415926535
      rad=180/pi
      write(*,1010)
   10 write(*,1020)
      read(*,*) z(1)
      if(z(1).le.0) then
      write(*,1510)
      write(*,1520)
      write(*,1530)
      go to 10
      else
      go to 20
      end if
   20 if(z(1).gt.118) then
      write(*,1510)
      write(*,1520)
      write(*,1530)
      go to 10
      else
      go to 30
      end if
   30 write(*,1030)
      read(*,*) z(3)
      if(z(3).le.0) then
      write(*,1510)
      write(*,1520)
      write(*,1530)
      go to 30
      else
      go to 40
      end if
   40 if(z(3).gt.118) then
      write(*,1510)
      write(*,1520)
      write(*,1530)
      go to 30
      else
      go to 50
      end if
   50 write(*,1040)
      read(*,*) adis1
      write(*,1050)
      read(*,*) adis2
   60 write(*,1060)
      read(*,*) dang1
      if(dang1.le.90) then
      write(*,1610)
      write(*,1620)
      write(*,1630)
      go to 60
      else
      go to 70
      end if
   70 if(dang1.ge.180) then
      write(*,1610)
      write(*,1620)
      write(*,1630)
      go to 60
      else
      go to 80
      end if
   80 bdis1=adis1/bohr
      bdis2=adis2/bohr
      dang2=dang1-90
      rang1=dang1/rad
      rang2=dang2/rad
      thr=3.0
      two=2.0
      hf=0.5
      sqt=sqrt(thr)
      hfsqt=hf*sqt
      adis3=adis2*sin(rang2)
      adis4=adis2*cos(rang2)
      bdis3=adis3/bohr
      bdis4=adis4/bohr
      z(2)=z(1)
      z(4)=z(3)
      z(5)=z(3)
      z(6)=z(3)
      z(7)=z(3)
      z(8)=z(3)
      n(1)=1
      n(2)=1
      n(3)=2
      n(4)=2
      n(5)=2
      n(6)=2
      n(7)=2
      n(8)=2
      a(1,1)=0.0
      a(1,2)=0.0
      a(1,3)=adis1*hf
      a(2,1)=0.0
      a(2,2)=0.0
      a(2,3)=-adis1*hf
      a(3,1)=adis4
      a(3,2)=0.0
      a(3,3)=(adis1*hf)+adis3
      a(4,1)=-adis4*hf
      a(4,2)=adis4*hfsqt
      a(4,3)=(adis1*hf)+adis3
      a(5,1)=-adis4*hf
      a(5,2)=-adis4*hfsqt
      a(5,3)=(adis1*hf)+adis3
      a(6,1)=-adis4
      a(6,2)=0.0
      a(6,3)=-(adis1*hf)-adis3
      a(7,1)=adis4*hf
      a(7,2)=adis4*hfsqt
      a(7,3)=-(adis1*hf)-adis3
      a(8,1)=adis4*hf
      a(8,2)=-adis4*hfsqt
      a(8,3)=-(adis1*hf)-adis3
      b(1,1)=0.0
      b(1,2)=0.0
      b(1,3)=bdis1*hf
      b(2,1)=0.0
      b(2,2)=0.0
      b(2,3)=-bdis1*hf
      b(3,1)=bdis4
      b(3,2)=0.0
      b(3,3)=(bdis1*hf)+bdis3
      b(4,1)=-bdis4*hf
      b(4,2)=bdis4*hfsqt
      b(4,3)=(bdis1*hf)+bdis3
      b(5,1)=-bdis4*hf
      b(5,2)=-bdis4*hfsqt
      b(5,3)=(bdis1*hf)+bdis3
      b(6,1)=-bdis4
      b(6,2)=0.0
      b(6,3)=-(bdis1*hf)-bdis3
      b(7,1)=bdis4*hf
      b(7,2)=bdis4*hfsqt
      b(7,3)=-(bdis1*hf)-bdis3
      b(8,1)=bdis4*hf
      b(8,2)=-bdis4*hfsqt
      b(8,3)=-(bdis1*hf)-bdis3
      write(7,3010)
      write(7,3020)
      write(7,3030)
      do 101 i=1,8
      write(7,1000) b(i,1),b(i,2),b(i,3),n(i)
  101 continue
      write(8,2010)
      do 201 i=1,8
      write(8,2020) z(i),n(i),a(i,1),a(i,2),a(i,3)
  201 continue
      write(8,2030)
      write(8,2040)
      write(8,2030)
      write(8,2050)
      write(8,2060)
      write(8,2070)
      write(8,2080)
      go to 204
  202 write(*,1001)
  203 write(*,1002)
  204 stop
 1000 format(3d20.10,i5)
 1001 format('*** Read Error ***')
 1002 format('*** Data Not Found ***')
 1010 format(/,'*** Program D3d26 (symOrb NON-SPIN version)',/,'*** for
     &A2B6 type molecule (e. g. C2H6)')
 1020 format(/,3x,'Input Atomic Number(Z) (1 <= Z <= 118) of Central Ato
     &m A, Z = ? ',$)
 1030 format(/,3x,'Input Atomic Number(Z) (1 <= Z <= 118) of Terminal At
     &om B, Z = ? ',$)
 1040 format(/,3x,'Input Distance(angstrom), A - A = ? ',$)
 1050 format(/,3x,'Input Distance(angstrom), A - B = ? ',$)
 1060 format(/,3x,'Input Angle(degree)( 90 deg.< Angle < 180 deg.), A-A-
     &B = ? ',$)
 1510 format(//,'     **************************************************
     &')
 1520 format('     *** Error *** Atomic Number(Z) (1 <= Z <= 118) ***')
 1530 format('     **************************************************',/
     &)
 1610 format(//,'     ***********************************************')
 1620 format('     *** Error *** A-A-B ( 90 deg.< Angle < 180 deg.)')
 1630 format('     ***********************************************',/)
 2010 format('| Z ||NEQ||   X    ||   Y    ||   Z    |')
 2020 format(2x,i3,1x,i4,3(f10.5))
 2030 format('---------------------------------------------')
 2040 format('|NEQ||  CHG   ||U/D||   RD   ||   VD   |    1')
 2050 format('    0     Unit     (0:angstrom  1:atomic)')
 2060 format('    0     Spin     (0:non-spin  1:spin  )')
 2070 format('    0     M.P.     (0:No        1:Yes   )')
 2080 format('20000     Sample Point ( <100000, =0 autoset )')
 3010 format('    8')
 3020 format('    1    1    1    1    1    1    1    1')
 3030 format('    1    1    1    1    2    0    2    0')
      end
