c======================================================================
c d6h66s ( D6h symmetry, A6B6 type Molecule (e. g. C6H6),
c                                                 symOrb SPIN version )
c  2006.03.31 Version 1.0 Sakane, Genta
c     ( Department of Chemistry, Okayama University of Science, Japan )
c  2016.11.30 Version 2.0 Genta Sakane added this program from Am to Og
c======================================================================
      program d6h66s
      real*8 a(12,3),b(12,3),bohr,adisaa,bdisaa,adisab,bdisab,adisob,
     &bdisob,thr,two,hf,sqt,hfsqt
      integer z(12),n(12)
      open (unit=07, form='formatted', status='unknown',
     &      access='sequential', file='d6h66s.out')
      open (unit=08, form='formatted', status='unknown',
     &      access='sequential', file='f01')
      bohr=0.5291772108
      pi=3.1415926535
      rad=180/pi
      write(*,1010)
   10 write(*,1020)
      read(*,*) z(1)
      if(z(1).le.0) then
      write(*,1510)
      write(*,1520)
      write(*,1530)
      go to 10
      else
      go to 20
      end if
   20 if(z(1).gt.118) then
      write(*,1510)
      write(*,1520)
      write(*,1530)
      go to 10
      else
      go to 30
      end if
   30 write(*,1030)
      read(*,*) z(7)
      if(z(7).le.0) then
      write(*,1510)
      write(*,1520)
      write(*,1530)
      go to 30
      else
      go to 40
      end if
   40 if(z(7).gt.118) then
      write(*,1510)
      write(*,1520)
      write(*,1530)
      go to 30
      else
      go to 50
      end if
   50 write(*,1040)
      read(*,*) adisaa
      write(*,1050)
      read(*,*) adisab
      adisob=adisaa+adisab
      bdisaa=adisaa/bohr
      bdisab=adisab/bohr
      bdisob=adisob/bohr
      thr=3.0
      two=2.0
      hf=0.5
      sqt=sqrt(thr)
      hfsqt=hf*sqt
      z(2)=z(1)
      z(3)=z(1)
      z(4)=z(1)
      z(5)=z(1)
      z(6)=z(1)
      z(8)=z(7)
      z(9)=z(7)
      z(10)=z(7)
      z(11)=z(7)
      z(12)=z(7)
      n(1)=1
      n(2)=1
      n(3)=1
      n(4)=1
      n(5)=1
      n(6)=1
      n(7)=2
      n(8)=2
      n(9)=2
      n(10)=2
      n(11)=2
      n(12)=2
      a(1,1)=0
      a(1,2)=adisaa
      a(1,3)=0
      a(2,1)=0
      a(2,2)=-adisaa
      a(2,3)=0
      a(3,1)=-hfsqt*adisaa
      a(3,2)=-hf*adisaa
      a(3,3)=0
      a(4,1)=hfsqt*adisaa
      a(4,2)=-hf*adisaa
      a(4,3)=0
      a(5,1)=-hfsqt*adisaa
      a(5,2)=hf*adisaa
      a(5,3)=0
      a(6,1)=hfsqt*adisaa
      a(6,2)=hf*adisaa
      a(6,3)=0
      a(7,1)=0
      a(7,2)=adisob
      a(7,3)=0
      a(8,1)=0
      a(8,2)=-adisob
      a(8,3)=0
      a(9,1)=-hfsqt*adisob
      a(9,2)=-hf*adisob
      a(9,3)=0
      a(10,1)=hfsqt*adisob
      a(10,2)=-hf*adisob
      a(10,3)=0
      a(11,1)=-hfsqt*adisob
      a(11,2)=hf*adisob
      a(11,3)=0
      a(12,1)=hfsqt*adisob
      a(12,2)=hf*adisob
      a(12,3)=0
      b(1,1)=0
      b(1,2)=bdisaa
      b(1,3)=0
      b(2,1)=0
      b(2,2)=-bdisaa
      b(2,3)=0
      b(3,1)=-hfsqt*bdisaa
      b(3,2)=-hf*bdisaa
      b(3,3)=0
      b(4,1)=hfsqt*bdisaa
      b(4,2)=-hf*bdisaa
      b(4,3)=0
      b(5,1)=-hfsqt*bdisaa
      b(5,2)=hf*bdisaa
      b(5,3)=0
      b(6,1)=hfsqt*bdisaa
      b(6,2)=hf*bdisaa
      b(6,3)=0
      b(7,1)=0
      b(7,2)=bdisob
      b(7,3)=0
      b(8,1)=0
      b(8,2)=-bdisob
      b(8,3)=0
      b(9,1)=-hfsqt*bdisob
      b(9,2)=-hf*bdisob
      b(9,3)=0
      b(10,1)=hfsqt*bdisob
      b(10,2)=-hf*bdisob
      b(10,3)=0
      b(11,1)=-hfsqt*bdisob
      b(11,2)=hf*bdisob
      b(11,3)=0
      b(12,1)=hfsqt*bdisob
      b(12,2)=hf*bdisob
      b(12,3)=0
      write(7,3010)
      write(7,3020)
      write(7,3030)
      write(7,3040)
      write(7,3050)
      do 101 i=1,12
      write(7,1000) b(i,1),b(i,2),b(i,3),n(i)
  101 continue
      write(8,2010)
      do 201 i=1,12
      write(8,2020) z(i),n(i),a(i,1),a(i,2),a(i,3)
  201 continue
      write(8,2030)
      write(8,2040)
      write(8,2030)
      write(8,2050)
      write(8,2060)
      write(8,2070)
      write(8,2080)
      go to 204
  202 write(*,1001)
  203 write(*,1002)
  204 stop
 1000 format(3d20.10,i5)
 1001 format('*** Read Error ***')
 1002 format('*** Data Not Found ***')
 1010 format(/,'*** Program D6h66s (symOrb SPIN version)',/,'*** for A6B
     &6 type Molecule (e. g. C6H6)')
 1020 format(/,3x,'Input Atomic Number(Z) (1 <= Z <= 118) of Inner Atom
     &A, Z = ? ',$)
 1030 format(/,3x,'Input Atomic Number(Z) (1 <= Z <= 118) of Terminal At
     &om B, Z = ? ',$)
 1040 format(/,3x,'Input Distance(angstrom), A - A = ? ',$)
 1050 format(/,3x,'Input Distance(angstrom), A - B = ? ',$)
 1510 format(//,'     **************************************************
     &')
 1520 format('     *** Error *** Atomic Number(Z) (1 <= Z <= 118) ***')
 1530 format('     **************************************************',/
     &)
 2010 format('| Z ||NEQ||   X    ||   Y    ||   Z    |')
 2020 format(2x,i3,1x,i4,3(f10.5))
 2030 format('---------------------------------------------')
 2040 format('|NEQ||  CHG   ||U/D||   RD   ||   VD   |    1')
 2050 format('    0     Unit     (0:angstrom  1:atomic)')
 2060 format('    1     Spin     (0:non-spin  1:spin  )')
 2070 format('    0     M.P.     (0:No        1:Yes   )')
 2080 format('20000     Sample Point ( <100000, =0 autoset )')
 3010 format('   16')
 3020 format('    1    1    1    1    1    1    1    1    1    1')
 3030 format('    1    1    1    1    1    1')
 3040 format('    1    1    1    1    2    0    2    0    1    1')
 3050 format('    1    1    2    0    2    0')
      end
