c======================================================================
c D8h2 ( D(infinity)h Symmetry(Continuous Group)
c                              Homonuclear Diatomic Molecule (e. g. N2)
c  2006.03.20 Version 1.0 Sakane, Genta
c     ( Department of Chemistry, Okayama University of Science, Japan )
c  2016.11.30 Version 2.0 Genta Sakane added this program from Am to Og
c======================================================================
      program d8h2
      real*8 a(2,3),b(2,3),bohr,adis,bdis,ahfdis,bhfdis
      integer z(2),n(2)
      open (unit=07, form='formatted', status='unknown',
     &      access='sequential', file='d8h2.out')
      open (unit=08, form='formatted', status='unknown',
     &      access='sequential', file='f01')
      bohr=0.5291772108
  110 write(*,1010)
      write(*,1020)
      write(*,1030)
      read(*,*,err=230) z(1)
      if(z(1).le.0) then
      write(*,1040)
      write(*,1050)
      write(*,1060)
      go to 110
      else
      go to 130
      end if
  130 if(z(1).gt.118) then
      write(*,1040)
      write(*,1050)
      write(*,1060)
      go to 110
      else
      go to 140
      end if
  140 z(2)=z(1)
      n(1)=1
      n(2)=1
      write(*,1070)
      read(*,*) adis
      ahfdis=adis/2
      bdis=adis/bohr
      bhfdis=ahfdis/bohr
      a(1,1)=0
      a(1,2)=0
      a(1,3)=ahfdis
      a(2,1)=0
      a(2,2)=0
      a(2,3)=-ahfdis
      b(1,1)=0
      b(1,2)=0
      b(1,3)=bhfdis
      b(2,1)=0
      b(2,2)=0
      b(2,3)=-bhfdis
      write(7,2010)
      write(7,2020)
      write(7,2030)
      write(7,2040)
      write(7,2050)
      do 210 i=1,2
      write(7,3010) b(i,1),b(i,2),b(i,3),n(i)
  210 continue
      write(8,4010)
      do 220 i=1,2
      write(8,4020) z(i),n(i),a(i,1),a(i,2),a(i,3)
  220 continue
      write(8,4030)
      write(8,4040)
      write(8,4030)
      write(8,4050)
      write(8,4060)
      write(8,4070)
      write(8,4080)
      go to 250
  230 write(*,5010)
  250 stop
 1010 format(/,'*** Program D(infinity)h2 (Continuous Group) ***')
 1020 format('*** for A2 type Homonuclear Diatomic Molecule (e. g. N2)')
 1030 format(/,3x,'Input Atomic Number(Z) (1 <= Z <= 118) of atom A, Z =
     & ? ',$)
 1040 format(//,'     **************************************************
     &')
 1050 format('     *** Error *** Atomic Number(Z) (1 <= Z <= 118) ***')
 1060 format('     **************************************************',/
     &)
 1070 format(/,3x,'Input Distance(angstrom), A - A = ? ',$)
 2010 format('   14')
 2020 format('    1    1    1    1    1    1    1    1    1    1')
 2030 format('    1    1    1    1')
 2040 format('    1    1    2    0    2    0    2    0    2    0')
 2050 format('    2    0    2    0')
 3010 format(3d20.10,i5)
 4010 format('| Z ||NEQ||   X    ||   Y    ||   Z    |')
 4020 format(2x,i3,1x,i4,3(f10.5))
 4030 format('---------------------------------------------')
 4040 format('|NEQ||  CHG   ||U/D||   RD   ||   VD   |    1')
 4050 format('    0     Unit     (0:angstrom  1:atomic)')
 4060 format('    0     Spin     (0:non-spin  1:spin  )')
 4070 format('    0     M.P.     (0:No        1:Yes   )')
 4080 format('20000     Sample Point ( <100000, =0 autoset )')
 5010 format(/,'*** Read Error ***',/)
      end
