c=======================================================================
c mh2o6n ( D2h symmetry, [M(H2O)6]n+ type Aqua Complex Cation,
c                                              symOrb NON-SPIN version )
c  2006.03.31 Version 1.0 Sakane, Genta
c     ( Department of Chemistry, Okayama University of Science, Japan )
c  2016.11.30 Version 2.0 Genta Sakane added this program from Am to Og
c=======================================================================
      program mh2o6n
      real*8 a(19,3),b(19,3),bohr,adis,bdis,ax,bx,ay,by,pi,rad,dang,rang
     &,hfdang,hfrang,aoh,boh,dhoh,rhoh,hfdhoh,hfrhoh,chg
      integer z(19),n(19)
      open (unit=07, form='formatted', status='unknown',
     &      access='sequential', file='mh2o6n.out')
      open (unit=08, form='formatted', status='unknown',
     &      access='sequential', file='f01')
      bohr=0.5291772108
      pi=3.1415926535
      rad=180/pi
c-----------------------------------------------------------------------
      aoh=0.9579
      dhoh=104.50
c-----------------------------------------------------------------------
      boh=aoh/bohr
      rhoh=dhoh/rad
      hfdhoh=dhoh/2
      hfrhoh=rhoh/2
      ax=aoh*cos(hfrhoh)
      ay=aoh*sin(hfrhoh)
      bx=boh*cos(hfrhoh)
      by=boh*sin(hfrhoh)
      write(*,1010)
      write(*,1011) aoh
      write(*,1012) dhoh
   10 write(*,1020)
      read(*,*) z(1)
      if(z(1).le.0) then
      write(*,1510)
      write(*,1520)
      write(*,1530)
      go to 10
      else
      go to 20
      end if
   20 if(z(1).gt.118) then
      write(*,1510)
      write(*,1520)
      write(*,1530)
      go to 10
      else
      go to 30
      end if
   30 write(*,1030)
      read(*,*) adis
      bdis=adis/bohr
      write(*,1040)
      read(*,*) chg
      z(2)=8
      z(3)=8
      z(4)=8
      z(5)=8
      z(6)=8
      z(7)=8
      z(8)=1
      z(9)=1
      z(10)=1
      z(11)=1
      z(12)=1
      z(13)=1
      z(14)=1
      z(15)=1
      z(16)=1
      z(17)=1
      z(18)=1
      z(19)=1
      n(1)=1
      n(2)=2
      n(3)=2
      n(4)=3
      n(5)=3
      n(6)=4
      n(7)=4
      n(8)=5
      n(9)=5
      n(10)=5
      n(11)=5
      n(12)=6
      n(13)=6
      n(14)=6
      n(15)=6
      n(16)=7
      n(17)=7
      n(18)=7
      n(19)=7
      a(1,1)=0
      a(1,2)=0
      a(1,3)=0
      a(2,1)=adis
      a(2,2)=0
      a(2,3)=0
      a(3,1)=-adis
      a(3,2)=0
      a(3,3)=0
      a(4,1)=0
      a(4,2)=adis
      a(4,3)=0
      a(5,1)=0
      a(5,2)=-adis
      a(5,3)=0
      a(6,1)=0
      a(6,2)=0
      a(6,3)=adis
      a(7,1)=0
      a(7,2)=0
      a(7,3)=-adis
      a(8,1)=adis+ax
      a(8,2)=ay
      a(8,3)=0
      a(9,1)=-adis-ax
      a(9,2)=-ay
      a(9,3)=0
      a(10,1)=-adis-ax
      a(10,2)=ay
      a(10,3)=0
      a(11,1)=adis+ax
      a(11,2)=-ay
      a(11,3)=0
      a(12,1)=0
      a(12,2)=adis+ax
      a(12,3)=ay
      a(13,1)=0
      a(13,2)=-adis-ax
      a(13,3)=ay
      a(14,1)=0
      a(14,2)=adis+ax
      a(14,3)=-ay
      a(15,1)=0
      a(15,2)=-adis-ax
      a(15,3)=-ay
      a(16,1)=ay
      a(16,2)=0
      a(16,3)=adis+ax
      a(17,1)=-ay
      a(17,2)=0
      a(17,3)=adis+ax
      a(18,1)=-ay
      a(18,2)=0
      a(18,3)=-adis-ax
      a(19,1)=ay
      a(19,2)=0
      a(19,3)=-adis-ax
      b(1,1)=0
      b(1,2)=0
      b(1,3)=0
      b(2,1)=bdis
      b(2,2)=0
      b(2,3)=0
      b(3,1)=-bdis
      b(3,2)=0
      b(3,3)=0
      b(4,1)=0
      b(4,2)=bdis
      b(4,3)=0
      b(5,1)=0
      b(5,2)=-bdis
      b(5,3)=0
      b(6,1)=0
      b(6,2)=0
      b(6,3)=bdis
      b(7,1)=0
      b(7,2)=0
      b(7,3)=-bdis
      b(8,1)=bdis+bx
      b(8,2)=by
      b(8,3)=0
      b(9,1)=-bdis-bx
      b(9,2)=-by
      b(9,3)=0
      b(10,1)=-bdis-bx
      b(10,2)=by
      b(10,3)=0
      b(11,1)=bdis+bx
      b(11,2)=-by
      b(11,3)=0
      b(12,1)=0
      b(12,2)=bdis+bx
      b(12,3)=by
      b(13,1)=0
      b(13,2)=-bdis-bx
      b(13,3)=by
      b(14,1)=0
      b(14,2)=bdis+bx
      b(14,3)=-by
      b(15,1)=0
      b(15,2)=-bdis-bx
      b(15,3)=-by
      b(16,1)=by
      b(16,2)=0
      b(16,3)=bdis+bx
      b(17,1)=-by
      b(17,2)=0
      b(17,3)=bdis+bx
      b(18,1)=-by
      b(18,2)=0
      b(18,3)=-bdis-bx
      b(19,1)=by
      b(19,2)=0
      b(19,3)=-bdis-bx
      write(7,3010)
      write(7,3020)
      write(7,3030)
      do 101 i=1,19
      write(7,1000) b(i,1),b(i,2),b(i,3),n(i)
  101 continue
      write(8,2010)
      do 201 i=1,19
      write(8,2020) z(i),n(i),a(i,1),a(i,2),a(i,3)
  201 continue
      write(8,2030)
      write(8,2040)
      write(8,2041) chg
      write(8,2030)
      write(8,2050)
      write(8,2060)
      write(8,2070)
      write(8,2080)
      go to 204
  202 write(*,1001)
  203 write(*,1002)
  204 stop
 1000 format(3d20.10,i5)
 1001 format('*** Read Error ***')
 1002 format('*** Data Not Found ***')
 1010 format(/,'*** Program MH2O6n (symOrb NON-SPIN version) *** for [M(
     &H2O)6]n+ type Aqua Complex Cation')
 1011 format(/,'*** Bond Distance (angstrom) O-H =',f7.4)
 1012 format(/,'*** Bond Angle (degree) H-O-H =',f7.2)
 1020 format(/,3x,'Input Atomic Number(Z) (1 <= Z <= 118) of Central Met
     &al Atom M, Z = ? ',$)
 1030 format(/,3x,'Input Distance(angstrom), M - O (OH2) = ? ',$)
 1040 format(/,3x,'Input Oxidation Number of Metal Atom, [M(H2O)6]n+, n
     &= ? ',$)
 1510 format(//,'     **************************************************
     &')
 1520 format('     *** Error *** Atomic Number(Z) (1 <= Z <= 118) ***')
 1530 format('     **************************************************',/
     &)
 2010 format('| Z ||NEQ||   X    ||   Y    ||   Z    |')
 2020 format(2x,i3,1x,i4,3(f10.5))
 2030 format('---------------------------------------------')
 2040 format('|NEQ||  CHG   ||U/D||   RD   ||   VD   |    1')
 2041 format('    1',f10.5)
 2050 format('    0     Unit     (0:angstrom  1:atomic)')
 2060 format('    0     Spin     (0:non-spin  1:spin  )')
 2070 format('    0     M.P.     (0:No        1:Yes   )')
 2080 format('20000     Sample Point ( <100000, =0 autoset )')
 3010 format('    8')
 3020 format('    1    1    1    1    1    1    1    1')
 3030 format('    1    1    1    1    1    1    1    1')
      end
