c======================================================================
c ml4s ( Td symmetry, [ML4]n(+or-) type Complex Ion (e. g. [CoCl4]2-),
c                                                 symOrb SPIN version )
c  2006.07.01 Version 1.0 Sakane, Genta
c     ( Department of Chemistry, Okayama University of Science, Japan )
c  2016.11.30 Version 2.0 Genta Sakane added this program from Am to Og
c======================================================================
      program ml4s
      real*8 a(5,3),b,c,d,e,f(5,3),g,dis,bohr,chg(2)
      integer z(5),n(5)
      open (unit=07, form='formatted', status='unknown',
     &      access='sequential', file='ml4s.out')
      open (unit=08, form='formatted', status='unknown',
     &      access='sequential', file='f01')
      b=0.5
      c=3.0
      d=sqrt(c)
      bohr=0.5291772108
      write(*,1020)
   10 write(*,1030)
      read(*,*) z(1)
      if(z(1).le.0) then
      write(*,1510)
      write(*,1520)
      write(*,1530)
      go to 10
      else
      go to 20
      end if
   20 if(z(1).gt.118) then
      write(*,1510)
      write(*,1520)
      write(*,1530)
      go to 10
      else
      go to 30
      end if
   30 write(*,1031)
      read(*,*) chg(1)
   40 write(*,1040)
      read(*,*) z(2)
      if(z(2).le.0) then
      write(*,1510)
      write(*,1520)
      write(*,1530)
      go to 40
      else
      go to 50
      end if
   50 if(z(2).gt.118) then
      write(*,1510)
      write(*,1520)
      write(*,1530)
      go to 40
      else
      go to 60
      end if
   60 z(3)=z(2)
      z(4)=z(2)
      z(5)=z(2)
      write(*,1041)
      read(*,*) chg(2)
      n(1)=1
      n(2)=2
      n(3)=2
      n(4)=2
      n(5)=2
      write(*,1050)
      read(*,*) dis
      e=(dis/d)/bohr
      g=dis/d
      a(1,1)=0
      a(1,2)=0
      a(1,3)=0
      a(2,1)=e
      a(2,2)=e
      a(2,3)=e
      a(3,1)=e
      a(3,2)=-e
      a(3,3)=-e
      a(4,1)=-e
      a(4,2)=e
      a(4,3)=-e
      a(5,1)=-e
      a(5,2)=-e
      a(5,3)=e
      f(1,1)=0
      f(1,2)=0
      f(1,3)=0
      f(2,1)=g
      f(2,2)=g
      f(2,3)=g
      f(3,1)=g
      f(3,2)=-g
      f(3,3)=-g
      f(4,1)=-g
      f(4,2)=g
      f(4,3)=-g
      f(5,1)=-g
      f(5,2)=-g
      f(5,3)=g
      write(7,3010)
      write(7,3020)
      write(7,3030)
      write(7,1010) a(1,1),a(1,2),a(1,3),n(1)
      write(7,1010) a(2,1),a(2,2),a(2,3),n(2)
      write(7,1010) a(3,1),a(3,2),a(3,3),n(3)
      write(7,1010) a(4,1),a(4,2),a(4,3),n(4)
      write(7,1010) a(5,1),a(5,2),a(5,3),n(5)
      write(8,2010)
      do 201 i=1,5
      write(8,2020) z(i),n(i),f(i,1),f(i,2),f(i,3)
  201 continue
      write(8,2030)
      write(8,2040)
      write(8,2041) chg(1)
      write(8,2042) chg(2)
      write(8,2030)
      write(8,2050)
      write(8,2060)
      write(8,2070)
      write(8,2080)
      go to 204
  202 write(*,1001)
  203 write(*,1002)
  204 stop
 1001 format('*** Read Error ***')
 1002 format('*** Data Not Found ***')
 1010 format(3d20.10,i5)
 1020 format(/,'*** Program ML4n (symOrb SPIN version)',/,'*** for [ML4]
     &n+ or [ML4]n- type Complex Ion')
 1030 format(/,3x,'Input Atomic Number(Z) (1 <= Z <= 118) of Central Ato
     &m M, Z = ? ',$)
 1031 format(/,3x,'Input Charge(Oxidation Number) of Central Atom M = ?
     &',$)
 1040 format(/,3x,'Input Atomic Number(Z) (1 <= Z <= 118) of Terminal At
     &om L, Z = ? ',$)
 1041 format(/,3x,'Input Charge(Oxidation Number) of Terminal Atom L = ?
     & ',$)
 1050 format(/,3x,'Input Distance(angstrom), M - L = ? ',$)
 1510 format(//,'     **************************************************
     &')
 1520 format('     *** Error *** Atomic Number(Z) (1 <= Z <= 118) ***')
 1530 format('     **************************************************',/
     &)
 2010 format('| Z ||NEQ||   X    ||   Y    ||   Z    |')
 2020 format(2x,i3,1x,i4,3(f10.5))
 2030 format('---------------------------------------------')
 2040 format('|NEQ||  CHG   ||U/D||   RD   ||   VD   |    1')
 2041 format('    1',f10.5)
 2042 format('    2',f10.5)
 2050 format('    0     Unit     (0:angstrom  1:atomic)')
 2060 format('    1     Spin     (0:non-spin  1:spin  )')
 2070 format('    0     M.P.     (0:No        1:Yes   )')
 2080 format('20000     Sample Point ( <100000, =0 autoset )')
 3010 format('   10')
 3020 format('    1    1    1    1    1    1    1    1    1    1')
 3030 format('    1    1    2    0    3    0    0    3    0    0')
      end
