c======================================================================
c oh16n ( Oh symmetry, AB6 type Molecule (e. g. SF6),
c                                             symOrb NON-SPIN version )
c  2006.03.31 Version 1.0 Sakane, Genta
c     ( Department of Chemistry, Okayama University of Science, Japan )
c  2016.11.30 Version 2.0 Genta Sakane added this program from Am to Og
c======================================================================
      program oh16n
      real*8 a(7,3),b,c,d,e,f(7,3),g,dis,bohr
      integer z(7),n(7)
      open (unit=07, form='formatted', status='unknown',
     &      access='sequential', file='oh16n.out')
      open (unit=08, form='formatted', status='unknown',
     &      access='sequential', file='f01')
      b=0.5
      c=3.0
      d=sqrt(c)
      bohr=0.5291772108
      write(*,119)
   10 write(*,120)
      read(*,*) z(1)
      if(z(1).le.0) then
      write(*,1510)
      write(*,1520)
      write(*,1530)
      go to 10
      else
      go to 20
      end if
   20 if(z(1).gt.118) then
      write(*,1510)
      write(*,1520)
      write(*,1530)
      go to 10
      else
      go to 30
      end if
   30 write(*,121)
      read(*,*) z(2)
      if(z(2).le.0) then
      write(*,1510)
      write(*,1520)
      write(*,1530)
      go to 30
      else
      go to 40
      end if
   40 if(z(2).gt.118) then
      write(*,1510)
      write(*,1520)
      write(*,1530)
      go to 30
      else
      go to 50
      end if
   50 z(3)=z(2)
      z(4)=z(2)
      z(5)=z(2)
      z(6)=z(2)
      z(7)=z(2)
      n(1)=1
      n(2)=2
      n(3)=2
      n(4)=2
      n(5)=2
      n(6)=2
      n(7)=2
      write(*,122)
      read(*,*) dis
      e=dis/bohr
      g=dis
      a(1,1)=0
      a(1,2)=0
      a(1,3)=0
      a(2,1)=e
      a(2,2)=0
      a(2,3)=0
      a(3,1)=-e
      a(3,2)=0
      a(3,3)=0
      a(4,1)=0
      a(4,2)=e
      a(4,3)=0
      a(5,1)=0
      a(5,2)=-e
      a(5,3)=0
      a(6,1)=0
      a(6,2)=0
      a(6,3)=e
      a(7,1)=0
      a(7,2)=0
      a(7,3)=-e
      f(1,1)=0
      f(1,2)=0
      f(1,3)=0
      f(2,1)=g
      f(2,2)=0
      f(2,3)=0
      f(3,1)=-g
      f(3,2)=0
      f(3,3)=0
      f(4,1)=0
      f(4,2)=g
      f(4,3)=0
      f(5,1)=0
      f(5,2)=-g
      f(5,3)=0
      f(6,1)=0
      f(6,2)=0
      f(6,3)=g
      f(7,1)=0
      f(7,2)=0
      f(7,3)=-g
      write(7,3001)
      write(7,3002)
      write(7,3003)
      write(7,3004)
      write(7,3005)
      do 101 i=1,7
      write(7,110) a(i,1),a(i,2),a(i,3),n(i)
  101 continue
      write(8,2001)
      do 201 i=1,7
      write(8,2002) z(i),n(i),f(i,1),f(i,2),f(i,3)
  201 continue
      write(8,2003)
      write(8,2004)
      write(8,2003)
      write(8,2005)
      write(8,2006)
      write(8,2007)
      write(8,2008)
      go to 204
  202 write(*,1001)
  203 write(*,1002)
  204 stop
  110 format(3d20.10,i5)
  119 format(/,'*** Program Oh16n (symOrb NON-SPIN version)',/,'*** for
     &AB6 type molecule (e. g. SF6)')
  120 format(/,3x,'Input Atomic Number(Z) (1 <= Z <= 118) of central ato
     &m A, Z = ? ',$)
  121 format(/,3x,'Input Atomic Number(Z) (1 <= Z <= 118) of terminal at
     &om B, Z = ? ',$)
  122 format(/,3x,'Input Distance(angstrom), A - B = ? ',$)
 1001 format('*** Read Error ***')
 1002 format('*** Data Not Found ***')
 1510 format(//,'     **************************************************
     &')
 1520 format('     *** Error *** Atomic Number(Z) (1 <= Z <= 118) ***')
 1530 format('     **************************************************',/
     &)
 2001 format('| Z ||NEQ||   X    ||   Y    ||   Z    |')
 2002 format(2x,i3,1x,i4,3(f10.5))
 2003 format('---------------------------------------------')
 2004 format('|NEQ||  CHG   ||U/D||   RD   ||   VD   |    1')
 2005 format('    0     Unit     (0:angstrom  1:atomic)')
 2006 format('    0     Spin     (0:non-spin  1:spin  )')
 2007 format('    0     M.P.     (0:No        1:Yes   )')
 2008 format('20000     Sample Point ( <100000, =0 autoset )')
 3001 format('   20')
 3002 format('    1    1    1    1    1    1    1    1    1    1')
 3003 format('    0    1    1    1    1    1    1    1    1    1')
 3004 format('    1    1    2    0    3    0    0    3    0    0')
 3005 format('    1    1    2    0    3    0    0    3    0    0')
      end
