C***********************************************************************00010013
C   PROGRAM "READ36"   DV-XA OUTPUT F36.DATA ==> LOTUS 1 2 3 ETC..      00020013
C=======================================================================00030013
C   COPYRIGHT (C) G.SAKANE 1991    SHIBAHARA'S LABORATORY               00040013
C                                         OKAYAMA UNIVERSITY OF SCIENCE 00050013
C=======================================================================00060013
C   @INPUT DATA = FT05F001    @OUTPUT DATA = FT07F001                   00070013
C=======================================================================00080013
C         DV-XA  FILE 36 ===>   NUMBERS OF ITERATION CYCLES =< 10       00090014
C***********************************************************************00100013
      CHARACTER*1 SSS                                                   00110013
      INTEGER FLG                                                       00120013

c *******************************************************************
c  File Open Statments
c *******************************************************************

c ===================================================================
c  ((1))  Input Files
c ===================================================================

c     ---------------------------------------------------------------
c      (1-1) File 05 ... Scat File36
c     ---------------------------------------------------------------
      open (unit=05, form='formatted', status='old',
     &      access='sequential', file='F36')

c ===================================================================
c  ((2))  Output Files
c ===================================================================

c     ---------------------------------------------------------------
c      (2-1) File 07 ... Output Data
c     ---------------------------------------------------------------
      open (unit=07, form='formatted', status='unknown',
     &      access='sequential', file='F36.out')


      READ(5,100,ERR=10,END=20) FLG                                     00130013
      IF(FLG.EQ.1) GO TO 30                                             00140013
   10 WRITE(*,200)                                                      00150013
   20 GO TO 999                                                         00160013
   30 N=1                                                               00170013
      READ(5,300,ERR=10,END=20) SSS                                     00180013
      IF(SSS.EQ.'D') CALL SPIN                                          00190013
      IF(SSS.EQ.'K') CALL NONSPI                                        00200013
  100 FORMAT(I1/)                                                       00210013
  200 FORMAT(' ***** READ ERROR ***** ')                                00220013
  300 FORMAT(//11X,A1/)                                                 00230013
  999 END                                                               00240013
C **********************************************************************00250013
      SUBROUTINE SPIN                                                   00260013
      INTEGER M(0:10,500),LO(0:10,500),KIDO(0:10,500),ITERAT(10),FLG
      REAL SHOKI(0:10,500,2),SHUCHI(0:10,500,2),SA(10,500,2)
c     WRITE(*,100)                                                      00290013
      WRITE(*,200)                                                      00300013
      REWIND 5                                                          00310013
      NC=0                                                              00320013
    2 N=1                                                               00330013
    1 READ(5,300,ERR=10,END=20) FLG,M(NC,N),LO(NC,N),KIDO(NC,N),        00340013
     &SHOKI(NC,N,1),SHUCHI(NC,N,1),SHOKI(NC,N,2),SHUCHI(NC,N,2)         00350013
      IF(FLG.EQ.1) GO TO 5                                              00360013
      N=N+1                                                             00370013
      GO TO 1                                                           00380013
    5 NC=NC+1                                                           00390013
      READ(5,400,ERR=10,END=20) ITERAT(NC)                              00400013
      GO TO 2                                                           00410013
   10 WRITE(*,500)                                                      00420013
      GO TO 999                                                         00430013
   20 continue
c  20 WRITE(*,600)                                                      00440013
c     WRITE(*,110)                                                      00450013
c     WRITE(*,210)                                                      00460013
      I=N-1                                                             00470013
      DO 40 NS=1,2                                                      00480013
      WRITE(7,880)                                                      00490013
      IF(NS.EQ.1) WRITE(7,1001)                                         00500013
      IF(NS.EQ.2) WRITE(7,1002)                                         00510013
      WRITE(7,1000) ITERAT                                              00520013
      DO 30 K=1,I                                                       00530013
      WRITE(7,2000) LO(1,K),KIDO(1,K),SHUCHI(1,K,NS),SHUCHI(2,K,NS),    00540013
     &SHUCHI(3,K,NS),SHUCHI(4,K,NS),SHUCHI(5,K,NS),SHUCHI(6,K,NS),      00550013
     &SHUCHI(7,K,NS),SHUCHI(8,K,NS),SHUCHI(9,K,NS),SHUCHI(10,K,NS)
      DO 31 L=1,NC                                                      00600013
      SA(L,K,NS)=SHUCHI(L,K,NS)-SHOKI(L,K,NS)                           00610013
   31 CONTINUE                                                          00620013
   30 CONTINUE                                                          00630013
   40 CONTINUE                                                          00640013
      I=N-1                                                             00650013
      DO 45 NS=1,2                                                      00660013
      WRITE(7,881)                                                      00670013
      IF(NS.EQ.1) WRITE(7,1001)                                         00680013
      IF(NS.EQ.2) WRITE(7,1002)                                         00690013
      WRITE(7,1010) ITERAT                                              00700013
      DO 35 K=1,I                                                       00710013
      WRITE(7,2000) LO(1,K),KIDO(1,K),SA(1,K,NS),SA(2,K,NS),            00720013
     &SA(3,K,NS),SA(4,K,NS),SA(5,K,NS),SA(6,K,NS),                      00730013
     &SA(7,K,NS),SA(8,K,NS),SA(9,K,NS),SA(10,K,NS)
   35 CONTINUE                                                          00780013
   45 CONTINUE                                                          00790013
 1000 FORMAT(4X,20I9)                                                   00800014
 1001 FORMAT(' ( UP )')                                                 00810013
 1002 FORMAT(' (DOWN)')                                                 00820013
 1010 FORMAT(4X,10I9)                                                   00830014
 2000 FORMAT(I2,I4,1X,10F9.5)                                           00840014
  100 FORMAT(/,' ***** <<READ36>> START ***** ',/)                      00850013
  110 FORMAT(/,' ***** <<WRITE07>> START ***** ',/)                     00860013
  200 FORMAT(' */ READ36 SPIN VERSION /*',/)
  210 FORMAT(' */ FILE07 = SPIN VERSION /*',/)                          00880013
  300 FORMAT(I1,I2,1X,I2,I4,1X,F9.5,11X,F9.5,2X,F9.5,11X,F9.5,1X)       00890013
  400 FORMAT(//28X,I2/)                                                 00900013
  500 FORMAT(' ***** READ ERROR ***** ')                                00910013
  600 FORMAT(' ***** <<READ36>>  END  ***** ',//)                       00920013
  610 FORMAT(' ***** <<WRITE07>>  END  ***** ',//)                      00930013
  700 FORMAT(//)                                                        00940013
  880 FORMAT(//,' ***** SHUCHI ***** ')                                 00950013
  881 FORMAT(//,' ***** ( SHUCHI - SHOKI ) ***** ')                     00960013
c     WRITE(*,610)                                                      00970013
  999 RETURN                                                            00980013
      END                                                               00990013
C **********************************************************************01000013
      SUBROUTINE NONSPI                                                 01010013
      INTEGER M(0:10,500),LO(0:10,500),KIDO(0:10,500),ITERAT(10),FLG
      REAL SHOKI(0:10,500),SHUCHI(0:10,500),SA(10,500)
c     WRITE(*,100)                                                      01040013
      WRITE(*,200)                                                      01050013
      REWIND 5                                                          01060013
      NC=0                                                              01070013
    2 N=1                                                               01080013
    1 READ(5,300,ERR=10,END=20) FLG,M(NC,N),LO(NC,N),KIDO(NC,N),        01090013
     &SHOKI(NC,N),SHUCHI(NC,N)                                          01100013
      IF(FLG.EQ.1) GO TO 5                                              01110013
      N=N+1                                                             01120013
      GO TO 1                                                           01130013
    5 NC=NC+1                                                           01140013
      READ(5,400,ERR=10,END=20) ITERAT(NC)                              01150013
      GO TO 2                                                           01160013
   10 WRITE(*,500)                                                      01170013
      GO TO 999                                                         01180013
   20 continue
c  20 WRITE(*,600)                                                      01190013
c     WRITE(*,110)                                                      01200013
c     WRITE(*,210)                                                      01210013
      I=N-1                                                             01220013
      WRITE(7,880)                                                      01230013
      WRITE(7,1000) ITERAT                                              01240013
      DO 30 K=1,I                                                       01250013
      WRITE(7,2000) LO(1,K),KIDO(1,K),SHUCHI(1,K),SHUCHI(2,K),          01260013
     &SHUCHI(3,K),SHUCHI(4,K),SHUCHI(5,K),SHUCHI(6,K),                  01270013
     &SHUCHI(7,K),SHUCHI(8,K),SHUCHI(9,K),SHUCHI(10,K)
      DO 31 L=1,NC                                                      01320013
      SA(L,K)=SHUCHI(L,K)-SHOKI(L,K)                                    01330013
   31 CONTINUE                                                          01340013
   30 CONTINUE                                                          01350013
      I=N-1                                                             01360013
      WRITE(7,881)                                                      01370013
      WRITE(7,1010) ITERAT                                              01380013
      DO 35 K=1,I                                                       01390013
      WRITE(7,2000) LO(1,K),KIDO(1,K),SA(1,K),SA(2,K),                  01400013
     &SA(3,K),SA(4,K),SA(5,K),SA(6,K),                                  01410013
     &SA(7,K),SA(8,K),SA(9,K),SA(10,K)
   35 CONTINUE                                                          01460013
 1000 FORMAT(4X,10I9)                                                   01470014
 1010 FORMAT(4X,10I9)                                                   01480014
 2000 FORMAT(I2,I4,1X,10F9.5)                                           01490014
  100 FORMAT(/,' ***** <<READ36>> START ***** ',/)                      01500013
  110 FORMAT(/,' ***** <<WRITE07>> START ***** ',/)                     01510013
  200 FORMAT(' */ READ36 NON-SPIN VERSION /*',/)
  210 FORMAT(' */ FILE07 = NON-SPIN VERSION /*',/)                      01530013
  300 FORMAT(I1,2X,I2,3X,I2,1X,I4,6X,F9.5,21X,F9.5)                     01540013
  400 FORMAT(//28X,I2/)                                                 01550013
  500 FORMAT(' ***** READ ERROR ***** ')                                01560013
  600 FORMAT(' ***** <<READ36>>  END  ***** ',//)                       01570013
  610 FORMAT(' ***** <<WRITE07>>  END  ***** ',//)                      01580013
  700 FORMAT(//)                                                        01590013
  880 FORMAT(//,' ***** SHUCHI ***** ')                                 01600013
  881 FORMAT(//,' ***** ( SHUCHI - SHOKICHI ) ***** ')                  01610013
c     WRITE(*,610)                                                      01620013
  999 RETURN                                                            01630013
      END                                                               01640013
